# 機能設計書 7-next telemetry

## 概要

本ドキュメントは、Next.jsのテレメトリ有効/無効切替コマンド `next telemetry` の機能設計を記述する。匿名の利用統計収集の有効化・無効化・状態表示を行うCLIコマンドである。

### 本機能の処理概要

`next telemetry` コマンドは、Next.jsの匿名テレメトリ（利用統計収集）の有効/無効を切り替え、現在の状態を表示するCLIコマンドである。

**業務上の目的・背景**：Next.jsの開発チームはフレームワークの改善のために匿名の利用統計を収集している。開発者はプライバシーに配慮してテレメトリを無効化できる必要がある。`next telemetry` コマンドは、この設定を明示的に制御する手段を提供する。

**機能の利用シーン**：テレメトリのオプトアウト（無効化）を行いたい場合、またはテレメトリの現在の状態を確認したい場合に使用する。CI/CD環境では`NEXT_TELEMETRY_DISABLED`環境変数での制御も可能。

**主要な処理内容**：
1. テレメトリの有効化（`next telemetry enable` または `--enable`）
2. テレメトリの無効化（`next telemetry disable` または `--disable`）
3. テレメトリの状態表示（引数なし）
4. 設定ファイルへの永続化

**関連システム・外部連携**：テレメトリサーバー（データ送信先）、ローカルのConfストレージ

**権限による制御**：特段の権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 関連画面なし（CLIコンソール出力のみ） |

## 機能種別

CLIコマンド / 設定変更

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| arg | string | No | 'enable', 'disable', 'status'のいずれか | choices指定 |
| --enable | boolean | No | テレメトリを有効化 | --disableと排他 |
| --disable | boolean | No | テレメトリを無効化 | --enableと排他 |

### 入力データソース

- CLI引数（Commander.jsで解析）
- 既存のテレメトリ設定（Confストレージ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 操作結果メッセージ | string | 有効化/無効化の成功メッセージ |
| 現在のステータス | string | "Enabled" または "Disabled" |
| 追加情報 | string | 有効時は匿名性の説明、無効時はオプトアウトの確認 |
| ドキュメントURL | string | https://nextjs.org/telemetry |

### 出力先

- 標準出力（設定結果・状態表示）
- ローカルConfストレージ（設定の永続化）

## 処理フロー

### 処理シーケンス

```
1. Telemetryインスタンスの初期化
   └─ distDir: process.cwd() で初期化
2. 現在のテレメトリ状態を取得
   └─ telemetry.isEnabled で確認
3. 引数/オプションに応じた処理分岐
   3-a. enable: setEnabled(true)を呼び出し、成功メッセージ表示
   3-b. disable: setEnabled(false)を呼び出し、設定パス表示
   3-c. その他: "Next.js Telemetry"タイトル表示のみ
4. 現在のステータス表示
   └─ "Status: Enabled" または "Status: Disabled"
5. 追加情報の表示
   └─ 有効時: 匿名性の説明
   └─ 無効時: オプトアウト確認メッセージ
6. ドキュメントURLの表示
```

### フローチャート

```mermaid
flowchart TD
    A[next telemetry 実行] --> B[Telemetry初期化]
    B --> C{引数/オプション}
    C -->|enable| D[setEnabled true]
    C -->|disable| E[setEnabled false]
    C -->|なし/status| F[タイトル表示]
    D --> G[成功メッセージ]
    E --> H{既に無効?}
    H -->|Yes| I[既に無効メッセージ]
    H -->|No| J[設定保存パス表示]
    G --> K[ステータス表示]
    I --> K
    J --> K
    F --> K
    K --> L{有効?}
    L -->|Yes| M[匿名性の説明]
    L -->|No| N[オプトアウト確認]
    M --> O[ドキュメントURL表示]
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 引数とオプションの両方サポート | `next telemetry enable` と `next telemetry --enable` の両方を受け付ける | 常時 |
| BR-02 | --enableと--disableの排他 | Commander.jsのconflicts設定により同時指定を防止 | 常時 |
| BR-03 | 既に無効時のメッセージ | 既にテレメトリが無効の状態でdisableを実行した場合、既に無効であるメッセージを表示 | disable実行かつisEnabled === false時 |
| BR-04 | 設定の永続化 | テレメトリ設定はConfストレージに永続化される | enable/disable実行時 |

### 計算ロジック

なし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを操作しない。テレメトリ設定はConfストレージ（JSONファイル）に保存される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Conf初期化エラー | ストレージディレクトリへのアクセス権限がない | 適切な権限でディレクトリを作成 |

### リトライ仕様

なし。

## トランザクション仕様

なし。

## パフォーマンス要件

即座に完了する軽量な処理。

## セキュリティ考慮事項

- テレメトリデータは匿名であり、個人を特定できる情報は送信されない
- NEXT_TELEMETRY_DISABLED環境変数でも無効化可能

## 備考

- Telemetryクラスのインスタンスはモジュールレベルで`distDir: process.cwd()`として生成される（11行目）
- nextTelemetry関数は同期関数であり、非同期処理は含まれない
- テレメトリの詳細: https://nextjs.org/telemetry

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | next-telemetry.ts | `packages/next/src/cli/next-telemetry.ts` | NextTelemetryOptions型定義（6-9行目）。enable/disableのbooleanプロパティのみ |
| 1-2 | storage.ts | `packages/next/src/telemetry/storage.ts` | Telemetryクラス（51行目以降）。設定の永続化メカニズムとデータ送信の仕組み |

**読解のコツ**: next-telemetry.tsは53行と非常にコンパクト。picocolorsのbold/cyan/green/red/yellow関数でターミナル出力をカラーリングしている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | next.ts | `packages/next/src/bin/next.ts` | telemetryコマンドの定義（424-443行目）。Argumentでenable/disable/statusを選択肢として定義 |
| 2-2 | next-telemetry.ts | `packages/next/src/cli/next-telemetry.ts` | nextTelemetry関数（14-51行目） |

**主要処理フロー**:
1. **11行目**: モジュールレベルでTelemetryインスタンス生成
2. **12行目**: 初期状態の取得（isEnabled）
3. **15-17行目**: enable処理 - setEnabled(true)呼び出し
4. **20-31行目**: disable処理 - setEnabled(false)呼び出し、状態に応じたメッセージ分岐
5. **33行目**: 引数なしの場合はタイトル表示
6. **36-38行目**: 現在のステータス表示（green "Enabled" / red "Disabled"）
7. **40-48行目**: 有効/無効に応じた追加情報表示
8. **50行目**: ドキュメントURLの表示

#### Step 3: Telemetryクラスの永続化メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | storage.ts | `packages/next/src/telemetry/storage.ts` | Telemetryクラスのコンストラクタ（62-79行目）とsetEnabled/isEnabledの実装 |

**主要処理フロー**:
- **62-79行目**: Confストレージの初期化。CIやDockerではdistDirのcacheに保存
- **16行目**: TELEMETRY_KEY_ENABLED = 'telemetry.enabled'キーで有効/無効を管理

### プログラム呼び出し階層図

```
bin/next.ts (CLIエントリーポイント)
    │
    └─ cli/next-telemetry.ts::nextTelemetry()
           ├─ telemetry/storage.ts::Telemetry (インスタンス)
           │      ├─ Conf (JSONファイルストレージ)
           │      ├─ .isEnabled (getter)
           │      └─ .setEnabled(value) (setter)
           └─ console.log (結果出力)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CLI引数 ─────────────▶ nextTelemetry() ─────────────▶ ステータスメッセージ (stdout)
  (enable/disable)          │
                       Telemetry.setEnabled() ──────▶ Confストレージ (JSONファイル)
                              │
Confストレージ ──────▶ Telemetry.isEnabled ──────────▶ 現在の状態
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| next.ts | `packages/next/src/bin/next.ts` | ソース | CLIメインエントリーポイント |
| next-telemetry.ts | `packages/next/src/cli/next-telemetry.ts` | ソース | next telemetryコマンドのメイン処理 |
| storage.ts | `packages/next/src/telemetry/storage.ts` | ソース | テレメトリデータの管理・永続化 |
| post-telemetry-payload.ts | `packages/next/src/telemetry/post-telemetry-payload.ts` | ソース | テレメトリデータの送信 |
| anonymous-meta.ts | `packages/next/src/telemetry/anonymous-meta.ts` | ソース | 匿名メタデータの生成 |
| project-id.ts | `packages/next/src/telemetry/project-id.ts` | ソース | プロジェクトIDの生成 |
